//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//	
//	/X         X/  /X         X/    XXXXXX      +++++++++        XXXXX
//	/XX       XX/  /XX       XX/   XX    XXXX   /              XXX   XX
//	/ XX     XX /  / XX     XX /  XX        XX  /                     X
//	/  XX    X  /  /  XX    X  / XX             /                    XX
//	/   X   XX  /  /   X   XX  / X              /                XXXXXX
//	/   XX XX   /  /   XX XX   / X   XXXXXXXX   +++++++               XX
//	/    XXX    /  /    XXX    / X          XX  /                      X
//	/     XX    /  /     XX    / X           X  /              X       X
//	/     XX    /  /     XX    / XX         XX  /              XX     XX
//	/      X    /  /      X    /  XXXXXXXXXXX   ++++++++++      XXXXXXX
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//	MMGE 3 by Marty McFly 
//	fb.me/MartyMcModding
//
//	Do not redistribute!! Uploads to libertycity.ru and similiar sites
//	are strictly forbidden. This mod is GTAinside exclusive.
//	Generate traffic with something else, thanks.
//
//	Before you proceed to take from this whatever you want,
//	consider this: everyone knows this modification, if some feature
//	ends up somewhere else, everyone will know that you stole it
//	and you'll make a fool out of yourself.
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++



//+++++++++++++++++++++++++++++
//external parameters, do not modify
//+++++++++++++++++++++++++++++
//keyboard controlled temporary variables (in some versions exists in the config file). Press and hold key 1,2,3...8 together with PageUp or PageDown to modify. By default all set to 1.0
float4	tempF1; //0,1,2,3
float4	tempF2; //5,6,7,8
float4	tempF3; //9,0
//x=Width, y=1/Width, z=ScreenScaleY, w=1/ScreenScaleY
float4	ScreenSize;
//x=generic timer in range 0..1, period of 16777216 ms (4.6 hours), w=frame time elapsed (in seconds)
float4	Timer;
//additional info for computations
float4	TempParameters; 
//BloomRadius1, BloomRadius2, BloomBlueShiftAmount, BloomContrast
float4	BloomParameters;
//changes in range 0..1, 0 means that night time, 1 - day time
float	ENightDayFactor;
//changes 0 or 1. 0 means that exterior, 1 - interior
float	EInteriorFactor;
//changes in range 0..1, 0 means full quality, 1 lowest dynamic quality (0.33, 0.66 are limits for quality levels)
float	EAdaptiveQualityFactor;
//fov in degrees
float	FieldOfView;


texture2D texBloom1;
texture2D texBloom2;
texture2D texBloom3;
texture2D texBloom4;
texture2D texBloom5;
texture2D texBloom6;
texture2D texBloom7;//additional bloom tex
texture2D texBloom8;//additional bloom tex

sampler2D SamplerBloom1 = sampler_state
{
    Texture   = <texBloom1>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;//NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerBloom2 = sampler_state
{
    Texture   = <texBloom2>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;//NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerBloom3 = sampler_state
{
    Texture   = <texBloom3>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;//NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerBloom4 = sampler_state
{
    Texture   = <texBloom4>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;//NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerBloom5 = sampler_state
{
    Texture   = <texBloom5>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;//NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerBloom6 = sampler_state
{
    Texture   = <texBloom6>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;//NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerBloom7 = sampler_state
{
    Texture   = <texBloom7>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;//NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerBloom8 = sampler_state
{
    Texture   = <texBloom8>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;//NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

struct VS_OUTPUT_POST
{
	float4 vpos  : POSITION;
	float2 txcoord0 : TEXCOORD0;
};
struct VS_INPUT_POST
{
	float3 pos  : POSITION;
	float2 txcoord0 : TEXCOORD0;
};



//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
VS_OUTPUT_POST VS_Bloom(VS_INPUT_POST IN)
{
	VS_OUTPUT_POST OUT;

	OUT.vpos=float4(IN.pos.x,IN.pos.y,IN.pos.z,1.0);

	OUT.txcoord0.xy=IN.txcoord0.xy+TempParameters.xy;//1.0/(bloomtexsize*2.0)

	return OUT;
}

float	BloomPrePassRadius <  string UIName="BloomPrePassRadius"; string UIWidget="spinner"; float UIMin=0.0; float UIMax=10.0; > = {0.750};
float	BloomTex1Radius <  string UIName="BloomTex1Radius"; string UIWidget="spinner"; float UIMin=0.0; float UIMax=10.0; > = {4.000};
float	BloomTex2Radius <  string UIName="BloomTex2Radius"; string UIWidget="spinner"; float UIMin=0.0; float UIMax=10.0; > = {2.500};



float	BloomThresh <  string UIName="Bloom Threshold"; string UIWidget="spinner"; float UIMin=0.0; float UIMax=10.0; > = {0.00};

//zero pass HQ, input texture is fullscreen
//SamplerBloom1 - fullscreen texture
float4 PS_BloomPrePass(VS_OUTPUT_POST In) : COLOR
{
	float4 bloomuv;
	float4 bloom=0.0;
	float2 screenfact=TempParameters.z*BloomPrePassRadius;
	screenfact.y*=ScreenSize.z;

	float gaussweight[2] = {0.44198,0.27901};

	for(float x=-1; x<=1; x++)
	for(float y=-1; y<=1; y++)
	{
		float weight = gaussweight[abs(x)]*gaussweight[abs(y)];
		float2 curroffset = (float2(x,y)*screenfact.xy)+In.txcoord0.xy;

		float3 tempbloom = tex2D(SamplerBloom1, curroffset.xy);

		//if(In.txcoord0.x > 0.5) tempbloom.xyz = normalize(tempbloom.xyz+0.0001) * max(0.0,length(tempbloom.xyz)-BloomThresh);

		bloom.xyz += tempbloom.xyz * weight;
		bloom.w += weight;
	}

	float bloomlum = length(bloom.xyz);
	bloomlum = min(bloomlum,bloomlum*bloomlum*bloomlum);
	bloom.xyz = normalize(bloom.xyz+0.0001)*bloomlum;

	bloom.xyz /= bloom.w;
	return bloom;
}

float4 PS_BloomTexture1(VS_OUTPUT_POST In) : COLOR
{
	float4 bloomuv;
	float4 bloom=0.0;
	float2 screenfact=TempParameters.z*BloomTex1Radius;
	screenfact.y*=ScreenSize.z;

	float gaussweight[2] = {0.44198,0.27901};

	for(float x=-1; x<=1; x++)
	for(float y=-1; y<=1; y++)
	{
		float weight = gaussweight[abs(x)]*gaussweight[abs(y)];
		float2 curroffset = (float2(x,y)*screenfact.xy)+In.txcoord0.xy;
		bloom.xyz += tex2D(SamplerBloom1, curroffset.xy)*weight;
		bloom.w += weight;
	}

	bloom.xyz /= bloom.w;
	return bloom;

}

float4 PS_BloomTexture2(VS_OUTPUT_POST In) : COLOR
{

	float4 bloomuv;
	float4 bloom=0.0;
	float2 screenfact=TempParameters.z*BloomTex2Radius;
	screenfact.y*=ScreenSize.z;

	float gaussweight[2] = {0.44198,0.27901};

	float phi = 45.0 * 0.0174533;
	float2x2 rotMatrix = float2x2(cos(phi), -sin(phi), sin(phi), cos(phi));

	for(float x=-1; x<=1; x++)
	for(float y=-1; y<=1; y++)
	{
		float weight = gaussweight[abs(x)]*gaussweight[abs(y)];
		float2 currentcoord = mul(rotMatrix,float2(x,y))*screenfact.xy;
		bloom.xyz += tex2D(SamplerBloom1, currentcoord.xy +In.txcoord0.xy)*weight;
		bloom.w += weight;
	}

	bloom.xyz /= bloom.w;
	return bloom;
}

bool4 UseBloom6512 < string UIName = "Bloomtex 6512"; > = {true,false,false,false};
bool4 UseBloom3478 < string UIName = "Bloomtex 3478"; > = {false,false,false,false};


//last pass, mix several bloom textures
//SamplerBloom5 is the result of prepass
//float4 PS_BloomPostPass(float2 vPos : VPOS ) : COLOR
float4 PS_BloomPostPass(VS_OUTPUT_POST In) : COLOR
{
	float4 bloom = 0.0;
/*

				  bloom = tex2D(SamplerBloom6, In.txcoord0);
	if(In.txcoord0.x < 0.875) bloom = tex2D(SamplerBloom5, In.txcoord0);
	if(In.txcoord0.x < 0.750) bloom = tex2D(SamplerBloom1, In.txcoord0);
	if(In.txcoord0.x < 0.625) bloom = tex2D(SamplerBloom2, In.txcoord0);
	if(In.txcoord0.x < 0.500) bloom = tex2D(SamplerBloom3, In.txcoord0);
	if(In.txcoord0.x < 0.375) bloom = tex2D(SamplerBloom4, In.txcoord0);
	if(In.txcoord0.x < 0.250) bloom = tex2D(SamplerBloom7, In.txcoord0);
	if(In.txcoord0.x < 0.125) bloom = tex2D(SamplerBloom8, In.txcoord0);
*/
	bloom += tex2D(SamplerBloom6, In.txcoord0) * UseBloom6512.x;
	bloom += tex2D(SamplerBloom5, In.txcoord0) * UseBloom6512.y;
	bloom += tex2D(SamplerBloom1, In.txcoord0) * UseBloom6512.z;
	bloom += tex2D(SamplerBloom2, In.txcoord0) * UseBloom6512.w;
	bloom += tex2D(SamplerBloom3, In.txcoord0) * UseBloom3478.x;
	bloom += tex2D(SamplerBloom4, In.txcoord0) * UseBloom3478.y;
	bloom += tex2D(SamplerBloom7, In.txcoord0) * UseBloom3478.z;
	bloom += tex2D(SamplerBloom8, In.txcoord0) * UseBloom3478.w;	

	float divisor = UseBloom6512.x + UseBloom6512.y + UseBloom6512.z + UseBloom6512.w +  UseBloom3478.x + UseBloom3478.y + UseBloom3478.z + UseBloom3478.w + 0.001;

	bloom /= divisor;


	//bloom.xyz = lerp(bloom.xyz,bloom.xyz*saturate(1.0-0.5*dot(tex2D(SamplerBloom8, In.txcoord0).xyz,0.333)),1.0);



	return bloom;
}



technique BloomPrePass
{
    pass p0
    {
	VertexShader = compile vs_3_0 VS_Bloom();
	PixelShader  = compile ps_3_0 PS_BloomPrePass();

	ColorWriteEnable=ALPHA|RED|GREEN|BLUE;
	CullMode=NONE;
	AlphaBlendEnable=FALSE;
	AlphaTestEnable=FALSE;
	SEPARATEALPHABLENDENABLE=FALSE;
	FogEnable=FALSE;
	SRGBWRITEENABLE=FALSE;
	}
}

technique BloomTexture1
{
    pass p0
    {
	VertexShader = compile vs_3_0 VS_Bloom();
	PixelShader  = compile ps_3_0 PS_BloomTexture1();

	ColorWriteEnable=ALPHA|RED|GREEN|BLUE;
	CullMode=NONE;
	AlphaBlendEnable=FALSE;
	AlphaTestEnable=FALSE;
	SEPARATEALPHABLENDENABLE=FALSE;
	FogEnable=FALSE;
	SRGBWRITEENABLE=FALSE;
	}
}


technique BloomTexture2
{
    pass p0
    {
	VertexShader = compile vs_3_0 VS_Bloom();
	PixelShader  = compile ps_3_0 PS_BloomTexture2();

	ColorWriteEnable=ALPHA|RED|GREEN|BLUE;
	CullMode=NONE;
	AlphaBlendEnable=FALSE;
	AlphaTestEnable=FALSE;
	SEPARATEALPHABLENDENABLE=FALSE;
	FogEnable=FALSE;
	SRGBWRITEENABLE=FALSE;
	}
}

technique BloomPostPass
{
    pass p0
    {
	VertexShader = compile vs_3_0 VS_Bloom();
	PixelShader  = compile ps_3_0 PS_BloomPostPass();

	ColorWriteEnable=ALPHA|RED|GREEN|BLUE;
	CullMode=NONE;
	AlphaBlendEnable=FALSE;
	AlphaTestEnable=FALSE;
	SEPARATEALPHABLENDENABLE=FALSE;
	FogEnable=FALSE;
	SRGBWRITEENABLE=FALSE;
	}
}



